/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin;

import java.util.Optional;
import net.adventurez.entity.BlazeGuardianEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class MobSpawnerLogicMixin {
    @Shadow
    private int f_45442_ = 20;
    @Shadow
    private SpawnData f_45444_;
    private boolean spawnGuardian = false;

    @Inject(method={"setEntityId"}, at={@At(value="HEAD")})
    private void setEntityId(EntityType<?> type, @Nullable Level world, RandomSource random, BlockPos po, CallbackInfo info) {
        if (type != null && type.equals((Object)EntityType.f_20551_)) {
            this.spawnGuardian = true;
        }
    }

    @Inject(method={"readNbt"}, at={@At(value="HEAD")})
    private void readNbtMixin(@Nullable Level world, BlockPos pos, CompoundTag nbt, CallbackInfo info) {
        this.spawnGuardian = nbt.m_128471_("SpawnGuardian");
    }

    @Inject(method={"writeNbt"}, at={@At(value="HEAD")})
    private void writeNbtMixin(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> info) {
        nbt.m_128379_("SpawnGuardian", this.spawnGuardian);
    }

    @Inject(method={"serverTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/MobSpawnerLogic;spawnDelay:I", ordinal=1)})
    private void serverTick(ServerLevel world, BlockPos pos, CallbackInfo info) {
        if (this.f_45442_ == 2 && ConfigInit.CONFIG.allow_guardian_spawner_spawn) {
            Optional optionalEntityType;
            if (this.spawnGuardian) {
                BlazeGuardianEntity blazeGuardianEntity = (BlazeGuardianEntity)EntityInit.BLAZE_GUARDIAN.m_20615_((Level)world.m_6018_());
                blazeGuardianEntity.m_6518_((ServerLevelAccessor)world.m_6018_(), world.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                int randomCheck = world.f_46441_.m_188503_(3);
                blazeGuardianEntity.m_20035_(pos.m_122013_(world.f_46441_.m_188503_(3) - 1).m_122030_(randomCheck - 1 == 0 ? -1 : randomCheck), world.f_46441_.m_188501_() * 360.0f, 0.0f);
                world.m_7967_((Entity)blazeGuardianEntity);
                this.f_45442_ = 600;
                this.spawnGuardian = false;
            } else if (this.f_45444_ != null && this.f_45444_.m_186567_() != null && (optionalEntityType = EntityType.m_20637_((CompoundTag)this.f_45444_.m_186567_())).isPresent() && ((EntityType)optionalEntityType.get()).equals(EntityType.f_20551_) && !world.m_6443_(BlazeGuardianEntity.class, new AABB(pos).m_82400_(16.0), EntitySelector.f_20408_).isEmpty()) {
                this.f_45442_ = 600;
            }
        }
    }
}

